---
title: Setup · Cloudflare Aegis docs
description: You can control Aegis enablement on your zones via API. If you are
  not familiar with how Cloudflare API works, refer to Fundamentals.
lastUpdated: 2025-10-01T13:13:26.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/aegis/setup/
  md: https://developers.cloudflare.com/aegis/setup/index.md
---

You can control Aegis enablement on your zones [via API](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/). If you are not familiar with how Cloudflare API works, refer to [Fundamentals](https://developers.cloudflare.com/fundamentals/api/).

Availability

Cloudflare Aegis is available in early access to Enterprise customers. Contact your account team to request access.

## Requirements

* The Aegis zone setting endpoint is only available within Cloudflare accounts that own leased IPs, or accounts to which a [BYOIP prefix](https://developers.cloudflare.com/byoip/) has been delegated. If you wish to use Aegis for zones that do not meet this criteria, contact your account team.
* Each Aegis pool can consist of either IPs from a BYOIP prefix or Cloudflare-leased IPs. A single dedicated egress pool cannot contain both BYOIPs and leased IPs.

## Turn on Aegis for a zone

1. Contact your account team to get the ID for your dedicated egress pool.
2. Make a `PATCH` request to the [Edit Zone Setting](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) endpoint:

* Specify `aegis` as the setting ID in the URL.
* In the request body, set `enabled` to `true` and use the ID from the previous step as `pool_id`.

Required API token permissions

At least one of the following [token permissions](https://developers.cloudflare.com/fundamentals/api/reference/permissions/) is required:

* `Zone Settings Write`

```bash
curl "https://api.cloudflare.com/client/v4/zones/$ZONE_ID/settings/aegis" \
  --request PATCH \
  --header "Authorization: Bearer $CLOUDFLARE_API_TOKEN" \
  --json '{
    "id": "aegis",
    "value": {
        "enabled": true,
        "pool_id": "<YOUR_EGRESS_POOL_ID>"
    }
  }'
```

## Check your Aegis IPs

A list of your leased Aegis IPs (dedicated IPs for CDN egress) is available on the dashboard under [**IP addresses** > **Leased IPs**](https://dash.cloudflare.com/?to=/:account/ip-addresses/leased-ips).

If you are using BYOIP, refer to [**IP addresses** > **BYOIP prefixes**](https://dash.cloudflare.com/?to=/:account/ip-addresses/ip-prefixes) instead.
