---
title: How Workers interact with Cache Rules · Cloudflare Cache (CDN) docs
description: Your Workers script can override cache rule behavior, whether it is
  applied to a zone using Cloudflare or a zone that is not proxied through
  Cloudflare.
lastUpdated: 2025-05-28T15:52:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cache/interaction-cloudflare-products/workers-cache-rules/
  md: https://developers.cloudflare.com/cache/interaction-cloudflare-products/workers-cache-rules/index.md
---

Your Workers script can override [cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/) behavior, whether it is applied to a zone using Cloudflare or a zone that is not proxied through Cloudflare.

For example, if there is a cache rule configured to bypass cache for `example.com/foo`, but your Workers script sets `cacheEverything: true`, the script's setting will take precedence, and the request will be cached. The same applies if the request is made to a non-Cloudflare zone — the Worker's `cacheEverything` setting will still override.

## Precedence order

Cache behavior is determined by the following order of precedence:

1. Workers script settings
2. Cache rules
3. Page rules

Cache rules override page rule settings, and Workers scripts override cache rules. Among rules at the same level, the one with the highest specificity takes priority.

## Compatibility flags

This override behavior is controlled by [compatibility flags](https://developers.cloudflare.com/workers/configuration/compatibility-flags/):

* For the Fetch API: `request_cf_overrides_cache_rules`
* For the Cache API: `cache_api_request_cf_overrides_cache_rules`

These flags must be enabled to allow Workers scripts to override cache rules.

### Compatibility date behavior

Whether these flags are enabled by default depends on your Worker's compatibility date:

* **Fetch API (`request_cf_overrides_cache_rules`)**
  * Enabled by default for compatibility dates **on or after 2025-04-02**.

* **Cache API (`cache_api_request_cf_overrides_cache_rules`)**

  * Enabled by default for compatibility dates **on or after 2025-05-19**.

  * **Important:** For `cache_api_request_cf_overrides_cache_rules` to be recognized, you must also enable `cache_api_compat_flags`.

    * `cache_api_compat_flags` enables the compatibility flag functionality for Workers. If `cache_api_compat_flags` is not set, then no compatibility flags — even if configured — will be recognized by the Cache API.
    * `cache_api_compat_flags` is enabled by default for compatibility dates **on or after 2025-04-19**.

If your Worker has an earlier compatibility date than the ones listed above, the corresponding flags must be manually enabled; otherwise, cache behavior will follow the original cache rules instead of the Worker's settings.

### Example (Older compatibility date)

If a cache rule is configured to bypass cache for `example.com/foo`, and a Worker with a compatibility date of `2025-04-02` or earlier tries to set `cacheEverything: true`, the cache rule will take effect, and the response will not be cached.

Likewise, if using the Cache API without `cache_api_compat_flags` enabled, even if you enable `cache_api_request_cf_overrides_cache_rules`, the Cache API will not take effect.
