---
title: Interstitial Challenge Pages · Cloudflare challenges docs
description: An interstitial Challenge Page acts as a gate between the visitor
  and your website or application while Cloudflare verifies the authenticity of
  the visitor.
lastUpdated: 2025-10-13T17:48:00.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/
  md: https://developers.cloudflare.com/cloudflare-challenges/challenge-types/challenge-pages/index.md
---

An interstitial Challenge Page acts as a gate between the visitor and your website or application while Cloudflare verifies the authenticity of the visitor.

The Challenge Page intercepts the visitor from getting to the destination URL by holding the request and evaluating the browser environment for automated signals, and serving a Challenge. The visitor cannot reach their destination without passing the Challenge. Based on the signals indicated by their browser environment, the visitor may be asked to perform an interaction such as checking a box or selecting a button for further probing.

You can implement a Challenge Page to your website or application by creating a [WAF custom rule](https://developers.cloudflare.com/waf/custom-rules/).

Challenges are triggered by a rule in the [Web Application Firewall (WAF)](https://developers.cloudflare.com/waf/), [Bot Management](https://developers.cloudflare.com/bots/), or [Rate limiting](https://developers.cloudflare.com/waf/rate-limiting-rules/).

The level of interactivity and visibility of the Challenge Page depends on the Action that you select when creating the WAF rule for your website or application.

## Actions

The following Challenge types are the available actions when you create a WAF rule for a Challenge Page.

### Managed Challenge (recommended)

Managed Challenges are where Cloudflare dynamically chooses the appropriate type of Challenge served to the visitor based on the characteristics of a request from the signals indicated by their browser. This helps avoid [CAPTCHAs](https://www.cloudflare.com/learning/bots/how-captchas-work/), which also reduces the lifetimes of human time spent solving CAPTCHAs across the Internet.

Most human visitors are automatically verified and the Challenge Page will display **Successful**. However, if Cloudflare detects non-human attributes from the visitor's browser, they may be required to interact with the Challenge to solve it.

Unless there are specific compatibility issues or other reasons to use other types of Challenges, Cloudflare recommends you to use Managed Challenges for your custom rules.

Warning

Using Cloudflare Challenges along with Rules features may cause Challenge loops. Refer to [Rules troubleshooting](https://developers.cloudflare.com/rules/reference/troubleshooting/) for more information.

### Interactive Challenge

Interactive Challenge Pages offer the highest security for your website or application because it requires a visitor to interact with the Interstitial Challenge Page, presenting the visitor with an Interactive Challenge to solve.

For more information about why Cloudflare does not recommend using Interactive Challenge, in favor of Managed Challenge, refer to our [blog post](https://blog.cloudflare.com/end-cloudflare-captcha/).

### JavaScript Challenge (non-interactive)

With a JavaScript (JS) Challenge, Cloudflare makes the determination on whether or not the visitor is automated based on the limited information attained from their browser signals via an injected JavaScript. Then, it presents a Challenge Page that requires no interaction from a visitor except the JavaScript processed by their browser.

The visitor must wait until their browser finishes processing the JavaScript, which typically takes less than five seconds.

If the visitor passes the Challenge, the original request continues to the destination URL. If the Challenge fails or cannot be completed, the visitor is presented with another Interstitial Challenge Page.

## Compatibility limitations

Challenge Pages interrupt the request flow by returning a full HTML page for the user's browser to render and solve. This mechanism fails when the browser expects a non-HTML response, such as an AJAX or XHR (fetch) request.

To ensure your API calls are protected without breaking single-page applications (SPAs) or API integrations, Cloudflare recommends using Turnstile Pre-clearance.

By enabling Pre-clearance, the Turnstile widget issues a persistent clearance cookie (`cf_clearance`) upon successful human verification on an initial HTML page. This cookie pre-clears the visitor to interact with sensitive API endpoints secured by WAF rules, allowing you to deploy granular security without forcing a disruptive Challenge Page response.

For implementation details, refer to the [guidance on Pre-clearance for Turnstile](https://developers.cloudflare.com/cloudflare-challenges/concepts/clearance/#pre-clearance-support-in-turnstile).
