---
title: Keycloak (SAML) · Cloudflare One docs
description: Keycloak is an open source identity and access management solution
  built by JBoss. If you need a Keycloak lab environment for testing, refer to
  this example.
lastUpdated: 2025-10-27T17:49:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/keycloak/
  md: https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/keycloak/index.md
---

Keycloak is an open source identity and access management solution built by JBoss. If you need a Keycloak lab environment for testing, refer to [this example](https://github.com/mw866/tunnel-keycloak).

## Set up Keycloak (SAML)

To set up Keycloak (SAML) as your identity provider:

1. In Keycloak, select **Clients** in the navigation bar and create a new client.

2. Under **Client ID**, enter the following URL:

   ```txt
   https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback
   ```

   You can find your team name in [Cloudflare One](https://one.dash.cloudflare.com/) under **Settings** > **Team name**.

   ![SAML Client interface with team domain and callback in Client ID](https://developers.cloudflare.com/_astro/configure-client.gStYVFuK_Z1NJii6.webp)

3. Change the `Name ID Format` to `email`

4. Next, set the valid redirect URI to the Keycloak domain that you are using. For example, `https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/callback`.

5. Set the Master SAML Processing URL using the same Keycloak domain: `https://<keycloak_domain>/auth/realms/master/protocol/saml`.

6. If you wish to enable client signatures, enable `Client Signature Required` and select **save**.

   1. You will need to [follow the steps here to get the certificate and enable it in the Cloudflare dashboard](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/signed_authn/).

   2. Import the Access certificate you downloaded into the `SAML Keys` tab. Use `Certificate PEM` as the format.

7. Set the built-in protocol mapper for the `email` property.

   ![Protocol Mapper with email property set](https://developers.cloudflare.com/_astro/protocol-mapper.CZf2t0Ex_27FE3B.webp)

   Next, you will need to integrate with Cloudflare Access.

8. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Integrations** > **Identity providers**.

9. Under **Your identity providers**, select **Add new identity provider**.

10. Choose **SAML** on the next page.

    You will need to input the Keycloak details manually. The examples below should be replaced with the specific domains in use with Keycloak and Cloudflare Access.

    | Field | Example |
    | - | - |
    | Single Sign-On URL | `https://<keycloak_domain>/auth/realms/master/protocol/saml` |
    | IdP Entity ID or Issuer URL | `https://<unique_id>.cloudflareaccess.com/cdn-cgi/access/callback` |
    | Signing certificate | Use the X509 Certificate in the Realm Settings from Keycloak |

11. Select **Save**.

To test that your connection is working, go to **Integrations** > **Identity providers** and select **Test** next to the login method you want to test.
